/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.FileBean;
import com.ibm.hwmca.base.logd.FileFn;
import com.ibm.hwmca.base.logd.FormatText;
import com.ibm.hwmca.base.logd.HexExpanderTasklet;
import com.ibm.hwmca.base.logd.LogDisplayer;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.logd.TextDisplayerBean;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.logd.DisplayerExpanderData;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.Translator;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.ArrayList;

public class NativeE4ExpanderTasklet
extends HexExpanderTasklet
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDETT";
    private static final String TRACE_MASKD = "XLOGDETD";
    private static final String TRACE_MASKF = "XLOGDETF";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.logd.res.LogDisplayerRes";
    private static final String TEXT_PANEL_NAME = "TextDisplayerPanel";
    private static final String FILE_PANEL_NAME = "FilePanel";
    private int _whoIsIt;
    public static final int AM_EXPANDER = 1;
    public static final int AM_TEXT = 2;
    private DisplayerExpanderData displayExpanderData;
    private String _textData;

    public NativeE4ExpanderTasklet() {
        Trace.trace(TRACE_MASKT, "<> NativeE4ExpanderTasklet()");
        this._whoIsIt = 2;
        this._textData = null;
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> NativeE4ExpanderTasklet.service()");
        if (taskletRequest.isInitialRequest()) {
            DisplayerExpanderData displayerExpanderData = null;
            if (this._whoIsIt == 2) {
                displayerExpanderData = this.retrieveExpanderData(taskletRequest, taskletResponse);
            }
            if (!taskletResponse.isResponseSet()) {
                if (this._whoIsIt == 2) {
                    Trace.trace(TRACE_MASKF, "About to format the internal data as text");
                    byte[] detailsData = displayerExpanderData.getHexData();
                    ArrayList<LocalizableText> detailsList = new ArrayList<LocalizableText>();
                    int parseIx = 0;
                    int detailsLength = -1;
                    LocalizableText[] detailsText = null;
                    while (parseIx < detailsData.length && detailsLength != 0) {
                        detailsLength = NativeE4ExpanderTasklet.parseLength(detailsData, parseIx);
                        LocalizableText details = NativeE4ExpanderTasklet.unmarshalLocalizableText(detailsData, parseIx, detailsLength);
                        detailsList.add(details);
                        parseIx += detailsLength + 2;
                    }
                    detailsText = new LocalizableText[detailsList.size()];
                    detailsList.toArray(detailsText);
                    this._textData = "";
                    String newline = "\n";
                    int i = 0;
                    while (i < detailsText.length) {
                        String linedata = detailsText[i].toString();
                        int index = -1;
                        index = linedata.indexOf("{0}");
                        if (index != -1) {
                            linedata = linedata.substring(0, index) + linedata.substring(index + 3);
                        }
                        if ((index = linedata.indexOf("{1}")) != -1) {
                            linedata = linedata.substring(0, index) + linedata.substring(index + 3);
                        }
                        if ((index = linedata.indexOf("{2}")) != -1) {
                            linedata = linedata.substring(0, index) + linedata.substring(index + 3);
                        }
                        if ((index = linedata.indexOf("{3}")) != -1) {
                            linedata = linedata.substring(0, index) + linedata.substring(index + 3);
                        }
                        if ((index = linedata.indexOf("{4}")) != -1) {
                            linedata = linedata.substring(0, index) + linedata.substring(index + 3);
                        }
                        this._textData = this._textData + newline + linedata;
                        ++i;
                    }
                }
                int textDataLen = this._textData.length();
                Trace.trace(TRACE_MASKF, "Text string len=" + textDataLen);
                String text = FormatText.createText(this._textData);
                Trace.trace(TRACE_MASKF, "create bean data for the text expander.");
                TextDisplayerBean textDisplayerBean = new TextDisplayerBean();
                textDisplayerBean.setTextOutput(text);
                Trace.trace(TRACE_MASKF, "call to display text data");
                taskletResponse.openModalChild(AUIML_FILE_NAME, TEXT_PANEL_NAME, textDisplayerBean);
            }
        } else if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
            Trace.trace(TRACE_MASKF, "before the log terminate");
            taskletResponse.terminate();
        } else {
            String panelError = (String)taskletRequest.getData("panelError");
            if (panelError == null) {
                TaskActionEvent event = (TaskActionEvent)taskletRequest.getData("event");
                String command = event.getActionCommand();
                String panelName = (String)taskletRequest.getData("panelName");
                Trace.trace(TRACE_MASKF, "TextExpander's panel=" + panelName + " command=" + command);
                if (command.equals("CANCEL")) {
                    taskletResponse.dispose();
                } else if (panelName.equals("TextPanel")) {
                    if (command.equals("FileMenu.CancelItem")) {
                        taskletResponse.dispose();
                    } else if (command.equals("FileMenu.SaveItem")) {
                        Trace.trace(TRACE_MASKF, "Text displayer Save to File function");
                        FileBean fileBean = new FileBean();
                        fileBean.setFileNamePanel("FileNamePanelWrite");
                        taskletResponse.openModalChild(AUIML_FILE_NAME, FILE_PANEL_NAME, fileBean);
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown event received by the TextExpander panel. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                } else if (panelName.equals("FileNamePanelWrite")) {
                    if (command.equals("OkButton")) {
                        Trace.trace(TRACE_MASKF, "processing the file panel's OK request");
                        FileFn writeToFile = new FileFn();
                        try {
                            writeToFile.saveToFile((PanelTasklet)this, taskletRequest, taskletResponse, this._textData);
                        }
                        catch (HException hexc) {
                            Trace.trace(TRACE_MASKF, "HException caught in NativeE4ExpanderTasklet.service()");
                            Trace.trace(TRACE_MASKF, hexc);
                            TaskletException te = new TaskletException(hexc);
                            throw te;
                        }
                    } else if (command.equals("CancelButton")) {
                        Trace.trace(TRACE_MASKF, "processing the file panel's  CANCEL request");
                        taskletResponse.dispose();
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown event received by the (Text)File panel. command=" + command);
                        taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                    }
                } else if (panelName.equals("HexPanel")) {
                    Trace.trace(TRACE_MASKF, "calling the HexExpander service()");
                    super.service(taskletRequest, taskletResponse);
                }
            } else {
                Trace.trace(TRACE_MASKF, "NativeE4ExpanderTasklet panelErr=" + panelError);
                taskletResponse.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- NativeE4ExpanderTasklet.service()");
    }

    public void hexService(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<->  NativeE4ExpanderTasklet.hexService()");
        super.service(taskletRequest, taskletResponse);
    }

    public DisplayerExpanderData retrieveExpanderData(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<->  NativeE4ExpanderTasklet.retrieveExpanderData()");
        return super.retrieveExpanderData(taskletRequest, taskletResponse);
    }

    public void setUp(int whoIsIt, String textData) {
        Trace.trace(TRACE_MASKT, "-> NativeE4ExpanderTasklet.setUp()");
        this._whoIsIt = whoIsIt;
        this._textData = textData;
        Trace.trace(TRACE_MASKF, "whoIsIt=" + this._whoIsIt);
    }

    public void logException(Throwable e) {
        Trace.trace(TRACE_MASKT, "-> NativeE4ExpanderTasklet.logException()");
        Trace.trace(TRACE_MASKF, e);
        new FrameworkLog(_logInfo, 1364, e).log();
        Trace.trace(TRACE_MASKT, "<- NativeE4ExpanderTasklet.logException()");
    }

    private static int parseLength(byte[] array, int start) {
        int result = 0;
        byte[] length = NativeE4ExpanderTasklet.subarray(array, start, 2);
        if (length.length == 2) {
            result = ((length[0] & 0xFF) << 8) + (length[1] & 0xFF);
        }
        return result;
    }

    private static String parseToken(byte[] array, int start) {
        String result = null;
        int length = NativeE4ExpanderTasklet.parseLength(array, start);
        if (length > 0) {
            result = Translator.fromAscii(NativeE4ExpanderTasklet.subarray(array, start + 2, length));
        }
        return result;
    }

    private static byte[] subarray(byte[] array, int start, int length) {
        if (length + start > array.length) {
            length = array.length - start;
        }
        if (length < 0) {
            length = 0;
        }
        byte[] result = new byte[length];
        if (start < array.length) {
            System.arraycopy(array, start, result, 0, length);
        }
        return result;
    }

    private static LocalizableText unmarshalLocalizableText(byte[] array, int start, int length) {
        int parseIx = start + 2;
        String bundleName = NativeE4ExpanderTasklet.parseToken(array, parseIx);
        parseIx += 2;
        if (bundleName != null) {
            parseIx += bundleName.length();
        }
        String key = NativeE4ExpanderTasklet.parseToken(array, parseIx);
        parseIx += 2;
        if (key != null) {
            parseIx += key.length();
        }
        ArrayList<String> substList = new ArrayList<String>();
        while (parseIx < start + length + 2) {
            String substValue = NativeE4ExpanderTasklet.parseToken(array, parseIx);
            parseIx += 2;
            if (substValue == null) continue;
            substList.add(substValue);
            parseIx += substValue.length();
        }
        Object[] subst = null;
        if (substList.size() != 0) {
            subst = new String[substList.size()];
            substList.toArray(subst);
        }
        if (bundleName.endsWith(".properties")) {
            bundleName = bundleName.substring(0, bundleName.indexOf(".properties"));
        }
        LocalizableText result = new LocalizableText(bundleName, key, subst);
        return result;
    }
}

